/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;


abstract public class TernaryRead<P1, P2, P3, R> extends BinaryRead<P1, P2, R> {

    final protected P3 parameter3;

    @Override
    public int hashCode() {
        final int h1 = parameter != null ? parameter.hashCode() : 0;
        final int h2 = parameter2 != null ? parameter2.hashCode() : 0;
        final int h3 = parameter3 != null ? parameter3.hashCode() : 0;
        return 41 * (h1 + 31 * h2) + h3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        TernaryRead<?, ?, ?, ?> r = (TernaryRead<?, ?, ?, ?>) object;
        if(parameter != null) {
            if(!parameter.equals(r.parameter)) return false;
        } else if(r.parameter != null) return false;
        if(parameter2 != null) {
            if(!parameter2.equals(r.parameter2)) return false;
        } else if(r.parameter2 != null) return false;
        if(parameter3 != null) {
            if(!parameter3.equals(r.parameter3)) return false;
        } else if(r.parameter3 != null) return false;
        return true;
    }

    public TernaryRead(P1 parameter1, P2 parameter2, P3 parameter3) {
        super(parameter1, parameter2);
        this.parameter3 = parameter3;
    }

}
