/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.Resource;
import org.simantics.db.procedure.SyncSetListener;

abstract public class SetResourceRead2<T> extends SyncSetResourceRead<T> {

    final protected Resource resource2;

    @Override
    public int hashCode() {
        return resource.hashCode() + 31 * resource2.hashCode() + 41 * procedure.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        SetResourceRead2<?> r = (SetResourceRead2<?>)object;
        return resource.equals(r.resource) && resource2.equals(r.resource2) && procedure.equals(r.procedure);
    }

    @Override
    public int getFlags() {
        return 0;
    }

    public SetResourceRead2(Resource resource, Resource predicate, SyncSetListener<T> procedure) {
        super(resource, procedure);
        this.resource2 = predicate;
    }

}
