/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

abstract public class ResourceRead3<T> extends ResourceReadBase<T> {

	final protected Resource resource;
	final protected Resource resource2;
	final protected Resource resource3;

    @Override
    public int hashCode() {
        return resource.hashCode() + 51 * (resource2.hashCode() + 31 * resource3.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceRead3<?> r = (ResourceRead3<?>) object;
        return resource.equals(r.resource) && resource2.equals(r.resource2) && resource3.equals(r.resource3);
    }

    public ResourceRead3(Resource r1, Resource r2, Resource r3) {
    	if(r1 == null) throw new IllegalArgumentException("Null resource1.");
    	if(r2 == null) throw new IllegalArgumentException("Null resource2.");
    	if(r3 == null) throw new IllegalArgumentException("Null resource3.");
        this.resource = r1;
        this.resource2 = r2;
        this.resource3 = r3;
    }

    @Override
    public boolean isImmutable(ReadGraph graph) throws DatabaseException {
    	return graph.isImmutable(resource) && graph.isImmutable(resource2) && graph.isImmutable(resource3);
    }
    
}
