/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

abstract public class ResourceRead2<T> extends ResourceReadBase<T> {

	final protected Resource resource;
	final protected Resource resource2;

    @Override
    public int hashCode() {
        return resource.hashCode() + 31 * resource2.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceRead2<?> r = (ResourceRead2<?>)object;
        return resource.equals(r.resource) && resource2.equals(r.resource2);
    }

    public ResourceRead2(Resource resource, Resource resource2) {
    	if(resource == null) throw new IllegalArgumentException("Null resource.");
    	if(resource2 == null) throw new IllegalArgumentException("Null resource2.");
        this.resource = resource;
        this.resource2 = resource2;
    }
    
    @Override
    public boolean isImmutable(ReadGraph graph) throws DatabaseException {
    	return graph.isImmutable(resource) && graph.isImmutable(resource2);
    }

    
    @Override
    public String toString() {
    	return getClass().getSimpleName() + "|" + resource + "|" + resource2; 
    }
    
}
