/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.Resource;
import org.simantics.db.request.AsyncRead;

public abstract class ResourceAsyncRead3<T> implements AsyncRead<T> {

    final protected Resource resource;
    final protected Resource resource2;
    final protected Resource resource3;

    @Override
    final public int hashCode() {
        return resource.hashCode() + 41 * (resource2.hashCode() + 31 * resource3.hashCode());
    }

    @Override
    public int threadHash() {
    	return resource.hashCode() >>> 16;
    }
    
    @Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceAsyncRead3<?> r = (ResourceAsyncRead3<?>) object;
        return resource.equals(r.resource) && resource2.equals(r.resource2) && resource3.equals(r.resource3);
    }

    @Override
    public int getFlags() {
        return 0;
    }
    
    public ResourceAsyncRead3(Resource resource, Resource resource2, Resource resource3) {
        this.resource = resource;
        this.resource2 = resource2;
        this.resource3 = resource3;
    }

}
