/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ReadInterface;

public abstract class ResourceAsyncRead2<T> implements AsyncRead<T>, ReadInterface<T> {

    final protected Resource resource;
    final protected Resource resource2;

    @Override
    final public int hashCode() {
        final int h1 = resource != null ? resource.hashCode() : 0;
        final int h2 = resource2 != null ? resource2.hashCode() : 0;
        return h1 ^ h2;
    }

    @Override
    public int threadHash() {
    	return resource.hashCode() >>> 16;
    }
    
    @Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceAsyncRead2<?> r = (ResourceAsyncRead2<?>) object;
        if(resource != null) {
            if(!resource.equals(r.resource)) return false;
        } else if(r.resource != null) return false;
        if(resource2 != null) {
            if(!resource2.equals(r.resource2)) return false;
        } else if(r.resource2 != null) return false;
        return true;
    }

    @Override
    public int getFlags() {
        return 0;
    }
    
    public ResourceAsyncRead2(Resource resource, Resource resource2) {
        this.resource = resource;
        this.resource2 = resource2;
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncProcedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Procedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncProcedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncListener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Listener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncListener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public T request(RequestProcessor processor) throws DatabaseException {
    	return processor.syncRequest(this);
    }
    
}
