/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.ReadInterface;

public abstract class ResourceAsyncRead<T> implements AsyncRead<T>, ReadInterface<T> {

    final protected Resource resource;

    @Override
    final public int hashCode() {
        return resource.hashCode();
    }
    
    @Override
    public int threadHash() {
    	return resource.getThreadHash();
    }

    @Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceAsyncRead<?> r = (ResourceAsyncRead<?>) object;
        return resource.equals(r.resource);
    }

    @Override
    public int getFlags() {
        return 0;
    }
    
    public ResourceAsyncRead(Resource resource) {
    	if(resource == null) throw new IllegalArgumentException("Null resource.");
        this.resource = resource;
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncProcedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Procedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncProcedure<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }

    @Override
    public void request(AsyncRequestProcessor processor, AsyncListener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, Listener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public void request(AsyncRequestProcessor processor, SyncListener<T> procedure) {
    	processor.asyncRequest(this, procedure);
    }
    
    @Override
    public T request(RequestProcessor processor) throws DatabaseException {
    	return processor.syncRequest(this);
    }
    
    
}
