/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;


abstract public class QuaternaryRead<P1, P2, P3, P4, R> extends TernaryRead<P1, P2, P3, R> {

    final protected P4 parameter4;

    @Override
    public int hashCode() {
        final int h1 = parameter != null ? parameter.hashCode() : 0;
        final int h2 = parameter2 != null ? parameter2.hashCode() : 0;
        final int h3 = parameter3 != null ? parameter3.hashCode() : 0;
        final int h4 = parameter4 != null ? parameter4.hashCode() : 0;
        return 31 * (41 * (h1 + 31 * h2) + h3) + h4;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        QuaternaryRead<?, ?, ?, ?, ?> r = (QuaternaryRead<?, ?, ?, ?, ?>) object;
        if(parameter != null) {
            if(!parameter.equals(r.parameter)) return false;
        } else if(r.parameter != null) return false;
        if(parameter2 != null) {
            if(!parameter2.equals(r.parameter2)) return false;
        } else if(r.parameter2 != null) return false;
        if(parameter3 != null) {
            if(!parameter3.equals(r.parameter3)) return false;
        } else if(r.parameter3 != null) return false;
        if(parameter4 != null) {
            if(!parameter4.equals(r.parameter4)) return false;
        } else if(r.parameter4 != null) return false;
        return true;
    }

    public QuaternaryRead(P1 parameter1, P2 parameter2, P3 parameter3, P4 parameter4) {
        super(parameter1, parameter2, parameter3);
        this.parameter4 = parameter4;
    }

}
