/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.operation.Layer0X;

/**
 * Given an input resource that consists of resources representing other
 * resources, return a map: represented resource -> representing resource.
 * 
 * @author Antti Villberg
 */
public class MappedRelated extends ResourceRead2<Map<Resource, Resource>> {

    public MappedRelated(Resource flat, Resource relation) {
        super(flat, relation);
    }

    @Override
    public Map<Resource, Resource> perform(ReadGraph graph) throws DatabaseException {

        Layer0X L0X = Layer0X.getInstance(graph);
        Map<Resource, Resource> result = new HashMap<Resource, Resource>();

        for (Resource part : graph.getObjects(resource, resource2)) {
            Resource represents = graph.getPossibleObject(part, L0X.Represents);
            if (represents != null)
                result.put(represents, part);
        }

        return result;

    }

}
