/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncSetListener;
import org.simantics.db.procedure.SyncSetListener;

final public class SyncToAsyncSetProcedure<T> implements AsyncSetListener<T> {

	final private SyncSetListener<T> procedure;

	public SyncToAsyncSetProcedure(SyncSetListener<T> procedure) {
		this.procedure = procedure;
	}
	
	@Override
	final public void add(AsyncReadGraph graph, final T result) {
		graph.asyncRequest(new ReadRequest() {

			@Override
			public void run(ReadGraph graph) throws DatabaseException {
				procedure.add(graph, result);
			}
			
			@Override
			public String toString() {
			    return "Add [" + result + "] in " + SyncToAsyncSetProcedure.this.toString();
			}
			
			
		});
	}

    @Override
    final public void remove(AsyncReadGraph graph, final T result) {
        graph.asyncRequest(new ReadRequest() {

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                procedure.remove(graph, result);
            }
            
        });
    }

	@Override
	final public void exception(AsyncReadGraph graph, final Throwable t) {
        graph.asyncRequest(new ReadRequest() {

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                procedure.exception(graph, t);
            }
            
        });
	}

    @Override
    public boolean isDisposed() {
        return procedure.isDisposed();
    }

    @Override
    public String toString() {
        return "SyncToAsyncSetProcedure -> " + procedure;
   }

}
