/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.common.procedure.single.SingleSetListener;
import org.simantics.db.procedure.SetListener;

public class SetListenerToSingleSetListener<T> extends SingleSetListener<T> {

	final private SetListener<T> listener;
	
	public SetListenerToSingleSetListener(SetListener<T> listener) {
		this.listener = listener;
	}

	public void add(T result) {
		listener.add(result);
	}

	public void remove(T result) {
		listener.remove(result);
	}
	
	@Override
	public void exception(Throwable t) {
		listener.exception(t);
	}

	@Override
	public boolean isDisposed() {
		return listener.isDisposed();
	}
	
	@Override
	public int hashCode() {
		return listener.hashCode();
	}
	
	@Override
	public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (SetListenerToSingleSetListener.class != object.getClass())
            return false;
        SetListenerToSingleSetListener<?> r = (SetListenerToSingleSetListener<?>)object;
        return r.listener.equals(listener);
	}

}
