/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.ReadGraph;
import org.simantics.db.procedure.MultiListener;
import org.simantics.db.procedure.SyncMultiListener;

public class NoneToSyncMultiListener<T> implements SyncMultiListener<T> {

    private final MultiListener<T> procedure;

    public NoneToSyncMultiListener(MultiListener<T> procedure) {
        this.procedure = procedure;
    }

    @Override
    public void execute(ReadGraph graph, final T result) {
        procedure.execute(result);
    }

    @Override
    public void finished(ReadGraph graph) {
        procedure.finished();
    }

    @Override
    public void exception(ReadGraph graph, Throwable t) {
        procedure.exception(t);
    }

    @Override
    public boolean isDisposed() {
        return procedure.isDisposed();
    }

    @Override
    public String toString() {
        return "NoneToAsyncMultiListener -> " + procedure;
    }

}
