/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.wrapper;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.Listener;

final public class NoneToAsyncListener<T> implements AsyncListener<T> {

	final private Listener<T> procedure;

	public NoneToAsyncListener(Listener<T> procedure) {
		this.procedure = procedure;
	}
	
	@Override
	public void execute(AsyncReadGraph graph, final T result) {
        procedure.execute(result);
	}

	@Override
	public void exception(AsyncReadGraph graph, Throwable t) {
		procedure.exception(t);
	}

	@Override
	public boolean isDisposed() {
	    return procedure.isDisposed();
	}
	
    @Override
    public String toString() {
        return "NoneToAsyncListener -> " + procedure;
   }
    
    @Override
    public int hashCode() {
        return procedure.hashCode();
    }
    
    @Override
    public boolean equals(Object arg0) {
        if(arg0 instanceof NoneToAsyncListener) {
            return procedure.equals(((NoneToAsyncListener<?>)arg0).procedure);
        } else {
            return procedure.equals(arg0);
        }
    }
	
}
