/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single.wrapper;

import java.util.concurrent.atomic.AtomicBoolean;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.procedure.AsyncProcedure;

final public class SingleOrErrorProcedure<Result> extends AsyncMultiProcedureAdapter<Result> {
    
	private Result result = null;
	final AsyncProcedure<Result> procedure;
    final AtomicBoolean found = new AtomicBoolean(false);
    final AtomicBoolean done = new AtomicBoolean(false);
    
    public SingleOrErrorProcedure(AsyncProcedure<Result> procedure) {
        this.procedure = procedure;
    }
	
    @Override
    public void finished(AsyncReadGraph graph) {
        
    	// Shall fire exactly once!
    	if(done.compareAndSet(false, true)) {
    		try {
    			if(result == null) {
					procedure.exception(graph, new NoSingleResultException("No items " + procedure, 0));
    			} else {
        			procedure.execute(graph, result);
    			}
    		} catch (Throwable t) {
        		Logger.defaultLogError(t);
    		}
    	}
        
    }
    
	public void execute(AsyncReadGraph graph, Result result) {

		if(found.compareAndSet(false, true)) {
			this.result = result;
		} else {
			// Shall fire exactly once!
			if(done.compareAndSet(false, true)) {
				try {
					procedure.exception(graph, new NoSingleResultException("Multiple items " + this.result + " and " + result, -1));
				} catch (Throwable t) {
		    		Logger.defaultLogError(t);
				}
			}
		}

	}

	public void exception(AsyncReadGraph graph, Throwable t) {
		// Shall fire exactly once!
		if(done.compareAndSet(false, true)) {
			try {
				procedure.exception(graph, t);
			} catch (Throwable t2) {
	    		Logger.defaultLogError(t2);
			}
		}
	}
    
    
    @Override
    public String toString() {
        return "SingleOrErrorProcedure -> " + procedure;
    }

}
