/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;

abstract public class StagedSingleSetSyncListener<T> implements SyncListener<Collection<T>>{
    
    private Collection<T> previous = null;
    
    public void start(ReadGraph graph, Collection<T> items) throws DatabaseException {}
    public void add(ReadGraph graph, T item) throws DatabaseException {}
    public void remove(ReadGraph graph, T item) throws DatabaseException {}
    
    @Override
    public synchronized void execute(ReadGraph graph, final Collection<T> result) throws DatabaseException {
    	
        if(previous == null) {

            start(graph, result);

        } else {

            HashSet<T> added = new HashSet<T>(result);
            added.removeAll(previous);
            HashSet<T> removed = new HashSet<T>(previous);
            removed.removeAll(result);

            for(T t : added) add(graph, t);
            for(T t : removed) remove(graph, t);

        }

        previous = result;
        
    }
    
    @Override
    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
		Logger.defaultLogError(throwable);
    }
    
}
