/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import java.util.HashSet;
import java.util.Set;

import org.simantics.db.procedure.Listener;

abstract public class StagedSingleSetListener<T> implements Listener<Set<T>>{
    
    private Set<T> previous = null;
    
    public void start(Set<T> items) {}
    public void add(T item) {}
    public void remove(T item) {}
    
    @Override
    public synchronized void execute(final Set<T> result) {
    	
        if(previous == null) {

            start(result);

        } else {

            HashSet<T> added = new HashSet<T>(result);
            added.removeAll(previous);
            HashSet<T> removed = new HashSet<T>(previous);
            removed.removeAll(result);

            for(T t : added) add(t);
            for(T t : removed) remove(t);

        }

        previous = result;
        
    }
    
}
