/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;

abstract public class SingleSetSyncListener<T> implements AsyncListener<Collection<T>>{
    
    private Collection<T> previous = null;
    
    /**
     * @param graph
     * @return <code>true</code> to continue, <code>false</code> to end processing here
     * @throws DatabaseException
     */
    public boolean start(ReadGraph graph) throws DatabaseException { return true; }
    public void add(ReadGraph graph, T item) throws DatabaseException {}
    public void remove(ReadGraph graph,T item) throws DatabaseException {}
    public void finished(ReadGraph graph) throws DatabaseException {}

    public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
		Logger.defaultLogError(t);
    }
    
    @Override
    final public void execute(AsyncReadGraph graph, final Collection<T> result) {
    	
    	if(result == null) {
    		Logger.defaultLogError("SingleSetSyncListener does not accept null result.");
    		return;
    	}
    	
    	graph.asyncRequest(new ReadRequest() {

			@Override
			public void run(ReadGraph graph) throws DatabaseException {

				if (!start(graph))
					return;

				if(previous == null) {

					for(T t : result) add(graph, t);

				} else {

					HashSet<T> added = new HashSet<T>(result);
					added.removeAll(previous);
					HashSet<T> removed = new HashSet<T>(previous);
					removed.removeAll(result);

					for(T t : added) add(graph, t);
					for(T t : removed) remove(graph, t);

				}

				finished(graph);

				previous = result;
				
			}
    		
    	}, new AsyncProcedure<Object>() {

			@Override
			public void exception(AsyncReadGraph graph, Throwable t) {
	    		Logger.defaultLogError(t);
			}

            @Override
            public void execute(AsyncReadGraph graph, Object result) {
            }
    		
    	});
        
    }
    
    @Override
    final public void exception(AsyncReadGraph graph, final Throwable throwable) {
        graph.asyncRequest(new ReadRequest() {

            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                exception((ReadGraph)graph, throwable);
            }

        });
    }
	
}
