/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.single;

import java.util.Collection;
import java.util.HashSet;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncListener;

abstract public class SingleSetAsyncListener<T> implements AsyncListener<Collection<T>>{
    
	final private boolean changesOnly;
	private Collection<T> previous = null;
    
    public void add(AsyncReadGraph graph, T item) {}
    public void remove(AsyncReadGraph graph, T item) {}
    
    public SingleSetAsyncListener() {
    	this(false);
    }
    
    public SingleSetAsyncListener(boolean changesOnly) {
    	this.changesOnly = changesOnly;
    }

    @Override
    public void execute(AsyncReadGraph graph, final Collection<T> result) {
    	
        if(previous == null) {

        	if(!changesOnly) {
//        		for(T t : result)
//        			add(graph, t);
//        	} else {
        		first(graph, result);
        	}

        } else {

            HashSet<T> added = new HashSet<T>(result);
            added.removeAll(previous);
            HashSet<T> removed = new HashSet<T>(previous);
            removed.removeAll(result);

            for(T t : added) add(graph, t);
            for(T t : removed) remove(graph, t);

        }

        previous = result;
        
    }
    
    public void first(AsyncReadGraph graph, final Collection<T> result) {
    	for(T t : result) add(graph, t);
    }
	
}
