/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncListener;

/*
 * Use this listener to ensure caching for a request. This listener will not lock the request in cache.
 * 
 */
public class TransientCacheAsyncListener <T> implements AsyncListener<T> {

    @SuppressWarnings("rawtypes")
    private static TransientCacheAsyncListener INSTANCE = new TransientCacheAsyncListener();

    @SuppressWarnings("unchecked")
    public static <T> TransientCacheAsyncListener<T> instance() {
        return (TransientCacheAsyncListener<T>) INSTANCE;
    }

    @Override
    public void exception(AsyncReadGraph graph, Throwable t) {
    }

    @Override
    public void execute(AsyncReadGraph graph, T result) {
    }

    @Override
    public final boolean isDisposed() {
        return true;
    }

    @Override
    public int hashCode() {
        return TransientCacheAsyncListener.class.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof TransientCacheAsyncListener;
    }

}