/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.adapter;

import java.util.concurrent.atomic.AtomicBoolean;

import org.simantics.db.procedure.Listener;

abstract public class StagedListener<T> implements Listener<T> {

	final private AtomicBoolean first = new AtomicBoolean(true); 
	
	@Override
    public void exception(Throwable t) {
    }

    @Override
    final public void execute(T result) {
    	if(first.compareAndSet(true, false)) {
    		first(result);
    	} else {
    		rest(result);
    	}
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    abstract public void first(T result);
    abstract public void rest(T result);

}
