/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncListener;

abstract public class ResourceAsyncListenerDelegate<T> implements AsyncListener<T> {
    
	final private Resource resource;
    final private AsyncListenerSupport support;
    
    public ResourceAsyncListenerDelegate(Resource resource, AsyncListenerSupport support) {
    	this.resource = resource;
        this.support = support;
    }

    @Override
    final public void exception(AsyncReadGraph graph, Throwable throwable) {
        support.exception(graph, throwable);
    }

    @Override
    final public boolean isDisposed() {
        return support.isDisposed();
    }

    @Override
    public int hashCode() {
        return resource.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ResourceAsyncListenerDelegate<?> r = (ResourceAsyncListenerDelegate<?>) object;
        return resource.equals(r.resource);
    }

}
