/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.procedure.adapter;

import org.simantics.db.procedure.Listener;

/*
 * Use this listener to ensure caching for a request. This listener will not lock the request in cache.
 * 
 */
final public class CacheListener<T> implements Listener<T> {

    final private ListenerSupport support;

    public CacheListener(ListenerSupport support) {
        this.support = support;
    }

    @Override
    final public void exception(Throwable throwable) {
        support.exception(throwable);
    }

    @Override
    final public boolean isDisposed() {
        return support.isDisposed();
    }

    @Override
    public void execute(T result) {
    }

    @Override
    public int hashCode() {
        return support.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (CacheListener.class != object.getClass())
            return false;
        CacheListener<?> r = (CacheListener<?>)object;
        return r.support.equals(support);
    }

}