package org.simantics.db.common;

import org.simantics.db.service.TransactionPolicySupport;

public class TransactionPolicyKeep implements TransactionPolicySupport {
    private boolean DEBUG = false;
    
    @Override
    public boolean holdOnToTransactionAfterCancel() {
        return true;
    }

    @Override
    public boolean holdOnToTransactionAfterCommit() {
        return true;
    }

    @Override
    public boolean holdOnToTransactionAfterRead() {
        return true;
    }

    @Override
    public void onRelinquish() {
        if (DEBUG)
            System.out.println("Empty onRelinquish for transaction policy keep.");
    }

    @Override
    public void onRelinquishDone() {
        if (DEBUG)
            System.out.println("Empty onRelinquishDone for transaction policy keep.");
    }

    @Override
    public void onRelinquishError() {
        if (DEBUG)
            System.out.println("Empty onRelinquishError for transaction policy keep.");
    }
}
