package org.simantics.db.common;

import java.io.IOException;
import java.io.ObjectInput;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.framework.wiring.BundleWiring;
import org.simantics.db.Session;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.scl.compiler.compilation.StoredModule;
import org.simantics.scl.compiler.elaboration.java.ExternalConstantReader;
import org.simantics.scl.compiler.module.options.StoredModuleSupport;

public class StandardStoredModuleSupport implements StoredModuleSupport {

	final private ExternalConstantReader constantReader;

	public StandardStoredModuleSupport(Session session) {
		SerialisationSupport ss = session.getService(SerialisationSupport.class);
		constantReader = new StandardExternalConstantReader(ss);
	}
	
	@Override
	public String getClassLoaderKey(ClassLoader loader) {
		if(loader instanceof BundleReference) {
			BundleReference ref = (BundleReference)loader;
			String key = ref.getBundle().getSymbolicName(); 
			return key;
		}
		return "";
	}
	
	@Override
	public ClassLoader getClassLoader(String key) {
		
		if(key.isEmpty())
			return StandardStoredModuleSupport.class.getClassLoader();
		
		Bundle bundle = Platform.getBundle(key);
		BundleWiring bundleWiring = bundle.adapt(BundleWiring.class);
		return bundleWiring.getClassLoader();
		
	}
	
	public ExternalConstantReader getExternalConstantReader() {
		return constantReader;
	}
	
	@Override
	public StoredModule readModule(ObjectInput in) throws IOException, ClassNotFoundException {
		return (StoredModule)in.readObject();
	}
	
}
