/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common;

import org.simantics.db.Resource;
import org.simantics.db.Statement;

public final class StandardStatement implements Statement, Comparable<Statement> {
	
    final private Resource s;
    final private Resource p;
    final private Resource o;
    
    public StandardStatement(final Resource s, final Resource p, final Resource o) {
        this.s = s;
        this.p = p;
        this.o = o;
    }
    
    @Override
    public Resource getObject() {
        return o;
    }

    @Override
    final public Resource getPredicate() {
        return p;
    }

    @Override
    final public Resource getSubject() {
        return s;
    }

    @Override
    public boolean isAsserted(Resource testSubject) {
    	return !s.equals(testSubject);
    }
    
    @Override
    final public int hashCode() {
        return 41 * ( 31 * s.hashCode() + p.hashCode()) + o.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof Statement))
            return false;
        Statement r = (Statement)object;
        return s.equalsResource(r.getSubject()) && p.equalsResource(r.getPredicate()) && o.equalsResource(r.getObject());
    }
    
    @Override
    public int compareTo(Statement other) {
        Statement impl = (Statement)other; 
        int result = s.compareTo(impl.getSubject());
        if(result != 0) return result;
        result = p.compareTo(impl.getPredicate());
        if(result != 0) return result;
        return o.compareTo(impl.getObject());
    }

}

