package org.simantics.db.common;

import org.simantics.db.ReadGraph;
import org.simantics.db.service.QueryControl;

public class QueryMemoryWatcher {

    final ReadGraph graph;
    final QueryControl support;
    final int stopTime;
    final long baseline;
    final long highLimit;
    final long lowLimit;
    boolean collecting = false;
    
    public QueryMemoryWatcher(ReadGraph graph, int allowedQueries) {
        this(graph, allowedQueries, 0.5, 10);
    }

    public QueryMemoryWatcher(ReadGraph graph, int allowedQueries, double ratio, int stopTime) {
        this.support = graph.getService(QueryControl.class);
        baseline = support.count();
        highLimit = baseline + allowedQueries;
        lowLimit = baseline + (int)(allowedQueries*ratio);
        this.graph = graph;
        this.stopTime = 10;
        //System.err.println("QueryMemoryWatcher started with " + baseline + " queries.");
    }
    
    public void maintain() {
        long current = support.count();
        if(collecting) {
            if(current > lowLimit) support.gc(graph, stopTime);
            else {
//                System.err.println("QueryMemoryWatcher stops collecting");
                collecting = false;
            }
        } else {
            if(current > highLimit) {
//                System.err.println("QueryMemoryWatcher starts collecting");
                collecting = true;
            }
        }
    }
    
}
