package org.simantics.db.common;

import java.lang.reflect.Method;
import java.util.Map;

import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.ServiceException;

public class MetadataUtils {

    private static final boolean TRACE_METADATA_SERIALIZATION = false;

    public static <T extends Metadata> boolean hasMetadata(Map<String,byte[]> metadata, Class<T> clazz) {
    	return metadata.containsKey(clazz.getName());
    }
    
    @SuppressWarnings("unchecked")
    public static <T extends Metadata> T getMetadata(Session session, Map<String,byte[]> metadata, Class<T> clazz) throws ServiceException {
        byte[] data = metadata.get(clazz.getName());
        if (TRACE_METADATA_SERIALIZATION) {
            if (data != null)
                System.out.println("deserializing " + data.length + " bytes of metadata into " + clazz);
        }
        Method m;
        try {
            m = clazz.getMethod("deserialise", Session.class, byte[].class);
            return (T) m.invoke(null, session, data);
        } catch (Exception e) {
            e.printStackTrace();
            Logger.defaultLogError(e.toString());
        }
        return null;
    }
    
    public static <T> void addMetadata(Session session, Map<String,byte[]> metadata, Metadata data) throws ServiceException {
        byte[] blob = data.serialise(session);
        if (TRACE_METADATA_SERIALIZATION)
            System.out.println("serialized " + blob.length + " bytes of metadata into for " + data.getClass());
        metadata.put(data.getClass().getName(), blob);
    }
    
}
