package org.simantics.db.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

import org.simantics.db.Metadata;
import org.simantics.db.Session;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.Serializers;

public abstract class ACommentMetadata implements Metadata {
    final boolean DEBUG = true;
    protected ArrayList<String> comments = new ArrayList<String>();
    public ACommentMetadata(TreeMap<String, byte[]> metadata) {
        if (null != metadata) {
            byte[] data = metadata.get(ACommentMetadata.class.getName());
            initialize(data);
        }
    }

    public ACommentMetadata(byte[] data) {
        initialize(data);
    }

    private void initialize(byte[] data) {
        if (null != data) {
            try {
                String[] strings = Serializers.deserializeStrings(data);
                for (String s : strings)
                    comments.add(s);
            } catch (Exception e) {
                Logger.defaultLogError(e);
            }
        }
    }

    public ACommentMetadata add(String string) {
        comments.add(string);
        return this;
    }
    
    public int size() {
    	return comments.size();
    }

    public ACommentMetadata add(ACommentMetadata cm) {
        if (null == cm)
            return this;
        comments.addAll(cm.comments);
        return this;
    }

    @Override
    public String toString() {
        String t = "";
        int size = comments.size();
        Iterator<String> it = comments.iterator();
        for (int i=0; i<size; ++i)
            t += it.next() + "\n";
        return t;
    }
    
    @Override
    public byte[] serialise(Session session) {
        try {
            return Serializers.serializeStrings(comments.toArray(new String[comments.size()]));
        } catch (Exception e) {
            if (DEBUG)
                e.printStackTrace();
            Logger.defaultLogError(e.toString());
        }
        return new byte[0];
    }
}
