/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.charts.query.TrendItemQuery;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.trend.configuration.TrendItem;

public class ChartSorterRule
implements SorterRule,
Sorter {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Sorter getSorter(ReadGraph graph, Object content) throws DatabaseException {
        return this;
    }

    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {
        try {
            ChartItemComparator cic = new ChartItemComparator();
            cic.graph = graph;
            Collections.sort(nodes, cic);
        }
        catch (RuntimeDatabaseException e) {
            if (e.getCause() != null && e.getCause() instanceof DatabaseException) {
                throw (DatabaseException)e.getCause();
            }
            throw e;
        }
    }

    static class ChartItemComparator
    implements Comparator<NodeContext> {
        ReadGraph graph;

        ChartItemComparator() {
        }

        @Override
        public int compare(NodeContext nc1, NodeContext nc2) {
            Resource r1 = (Resource)nc1.getConstant(BuiltinKeys.INPUT);
            Resource r2 = (Resource)nc2.getConstant(BuiltinKeys.INPUT);
            try {
                TrendItem ti1 = (TrendItem)this.graph.sync((ReadInterface)new TrendItemQuery(r1));
                TrendItem ti2 = (TrendItem)this.graph.sync((ReadInterface)new TrendItemQuery(r2));
                return ti1.compareTo((Bean)ti2);
            }
            catch (DatabaseException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
    }
}

