/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.awt.Color;
import java.text.Format;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.charts.query.ChartAndSubscriptionItemReadQuery;
import org.simantics.charts.ui.ChartAndSubscriptionItemDialog;
import org.simantics.charts.ui.ChartData;
import org.simantics.charts.ui.ChartDoubleClickHandler;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.chart.property.ChartComposite;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.trend.impl.Plot;
import org.simantics.utils.format.TimeFormat;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartDialog
extends Dialog {
    private static final RGB DEFAULT_BG_COLOR1 = ChartDialog.toRGB(Plot.PLOT_AREA_BG_GRADIENT_COLOR_BOTTOM.getColorComponents(new float[3]), null);
    private static final RGB DEFAULT_BG_COLOR2 = ChartDialog.toRGB(Plot.PLOT_AREA_BG_GRADIENT_COLOR_TOP.getColorComponents(new float[3]), null);
    private static final RGB DEFAULT_GRID_COLOR = ChartDialog.toRGB(Plot.GRID_LINE_COLOR.getColorComponents(new float[3]), null);
    Format timeFormat = new TimeFormat(100.0, 3);
    Label lName;
    Label lStartTime;
    Label lLength;
    Label lScrollIncrement;
    Label lAxisMode;
    Text tName;
    Text tStartTime;
    Text tLength;
    Scale sIncrement;
    Combo cAxisMode;
    Button bBackgroundGradient;
    ColorSelector backgroundColor1;
    ColorSelector backgroundColor2;
    Button bShowGrid;
    ColorSelector gridColor;
    Button bMilestones;
    Button bTrackExperimentTime;
    ListViewer lVisibleItems;
    ListViewer lHiddenItems;
    ControlDecoration tStartTimeDecor;
    ControlDecoration tLengthDecor;
    final ChartData baseData = new ChartData();
    final ChartData data;
    final Runnable applyAction;
    ChartAndSubscriptionItemDialog currentItemDialog = null;

    public ChartDialog(Shell parentShell, ChartData data, Runnable applyAction) {
        super(parentShell);
        this.data = data;
        this.baseData.readFrom(data);
        this.applyAction = applyAction;
        this.setShellStyle(2160);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.applyAction != null) {
            this.createButton(parent, 1025, "&Apply", true);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(9).applyTo(c);
        this.createDialogAreaContents(c);
        return c;
    }

    protected void createDialogAreaContents(Composite c) {
        String str;
        GridDataFactory gd1 = GridDataFactory.fillDefaults().align(4, 0x1000000).span(1, 1);
        GridDataFactory gd2 = GridDataFactory.fillDefaults().indent(5, 0).grab(true, false).span(8, 1);
        this.lName = new Label(c, 0);
        this.lName.setText("&Name:");
        gd1.applyTo((Control)this.lName);
        this.tName = new Text(c, 2048);
        this.tName.setEnabled(true);
        if (this.data.name != null) {
            this.tName.setText(this.data.name);
        }
        gd2.applyTo((Control)this.tName);
        Label l = new Label(c, 0);
        l.setText("Chart Time Window Preference (Auto-scale)");
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)l);
        this.lStartTime = new Label(c, 0);
        this.lStartTime.setText("&Time Start:");
        gd1.applyTo((Control)this.lStartTime);
        this.tStartTime = new Text(c, 2048);
        this.tStartTime.setToolTipText("Chart Window Fixed Start Time in Seconds or Yy Dd HH:mm:ss.ddd");
        if (this.data.timeStart != null) {
            str = this.timeFormat.format(this.data.timeStart);
            this.tStartTime.setText(str);
        }
        gd2.applyTo((Control)this.tStartTime);
        this.tStartTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartDialog.this.data.timeStart = ChartDialog.this.parseTime(ChartDialog.this.tStartTime, false, 0.0);
                ChartDialog.this.validate();
            }
        });
        this.lLength = new Label(c, 0);
        this.lLength.setText("&Length:");
        gd1.applyTo((Control)this.lLength);
        this.tLength = new Text(c, 2048);
        this.tLength.setToolTipText("Chart Window Fixed Time Axis Length in Seconds or Yy Dd HH:mm:ss.ddd");
        if (this.data.timeLength != null) {
            str = this.timeFormat.format(this.data.timeLength);
            this.tLength.setText(str);
        }
        gd2.applyTo((Control)this.tLength);
        this.tLength.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartDialog.this.data.timeLength = ChartDialog.this.parseTime(ChartDialog.this.tLength, false, 0.0);
                ChartDialog.this.validate();
            }
        });
        this.lScrollIncrement = new Label(c, 0);
        this.lScrollIncrement.setText("Scroll Increment:");
        gd1.applyTo((Control)this.lScrollIncrement);
        this.sIncrement = new Scale(c, 256);
        this.sIncrement.setMinimum(1);
        this.sIncrement.setMaximum(100);
        this.sIncrement.setIncrement(10);
        this.sIncrement.setPageIncrement(10);
        if (this.data.timeIncrement != null) {
            this.sIncrement.setSelection((int)this.data.timeIncrement.doubleValue());
        }
        gd2.copy().span(7, 1).applyTo((Control)this.sIncrement);
        final Text sIncrementText = new Text(c, 131080);
        gd1.copy().hint(35, -1).applyTo((Control)sIncrementText);
        this.sIncrement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                sIncrementText.setText(ChartDialog.this.sIncrement.getSelection() + " %");
            }
        });
        sIncrementText.setText(this.sIncrement.getSelection() + " %");
        this.lAxisMode = new Label(c, 0);
        this.lAxisMode.setText("A&xis Mode:");
        gd1.applyTo((Control)this.lAxisMode);
        this.cAxisMode = new Combo(c, 2060);
        GridDataFactory.fillDefaults().indent(5, 0).span(1, 1).applyTo((Control)this.cAxisMode);
        this.cAxisMode.add("Single");
        this.cAxisMode.add("Multi");
        String _mode = this.data.axisMode == YAxisMode.SingleAxis ? "Single" : "Multi";
        this.cAxisMode.setText(_mode);
        GridDataFactory.fillDefaults().span(7, 1).applyTo((Control)new Label(c, 0));
        this.bTrackExperimentTime = new Button(c, 32);
        this.bTrackExperimentTime.setText("Ha&irline Tracks Experiment Time");
        this.bTrackExperimentTime.setSelection(this.data.trackExperimentTime);
        GridDataFactory.fillDefaults().span(9, 1).applyTo((Control)this.bTrackExperimentTime);
        Group gStyling = new Group(c, 0);
        gStyling.setText("Styling");
        GridDataFactory.fillDefaults().indent(0, 5).grab(true, true).span(9, 1).applyTo((Control)gStyling);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(4).applyTo((Composite)gStyling);
        this.bBackgroundGradient = new Button((Composite)gStyling, 32);
        this.bBackgroundGradient.setText("&Background Vertical Gradient");
        this.bBackgroundGradient.setToolTipText("Solid Color or Vertical Gradient");
        this.bBackgroundGradient.setSelection(this.data.backgroundGradient);
        this.bBackgroundGradient.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartDialog.this.data.backgroundGradient = ChartDialog.this.bBackgroundGradient.getSelection();
                ChartDialog.this.setBackgroundGradient(ChartDialog.this.data.backgroundGradient);
            }
        });
        GridDataFactory.fillDefaults().indent(0, 0).span(1, 1).grab(false, false).applyTo((Control)this.bBackgroundGradient);
        this.backgroundColor1 = new ColorSelector((Composite)gStyling);
        this.backgroundColor2 = new ColorSelector((Composite)gStyling);
        this.backgroundColor1.getButton().setToolTipText("Select Gradient Bottom Color");
        this.backgroundColor2.getButton().setToolTipText("Select Gradient Top Color");
        GridDataFactory.fillDefaults().indent(0, 0).span(1, 1).grab(false, false).applyTo((Control)this.backgroundColor1.getButton());
        GridDataFactory.fillDefaults().indent(0, 0).span(1, 1).grab(false, false).applyTo((Control)this.backgroundColor2.getButton());
        this.backgroundColor1.setColorValue(ChartDialog.toRGB(this.data.backgroundColor1, DEFAULT_BG_COLOR1));
        this.backgroundColor2.setColorValue(ChartDialog.toRGB(this.data.backgroundColor2, DEFAULT_BG_COLOR2));
        this.setBackgroundGradient(this.data.backgroundGradient);
        Button bResetBackgroundColors = new Button((Composite)gStyling, 8);
        bResetBackgroundColors.setText("Reset");
        bResetBackgroundColors.setToolTipText("Reset Background Color to Default");
        bResetBackgroundColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartDialog.this.backgroundColor1.setColorValue(ChartDialog.toRGB(null, DEFAULT_BG_COLOR1));
                ChartDialog.this.backgroundColor2.setColorValue(ChartDialog.toRGB(null, DEFAULT_BG_COLOR2));
            }
        });
        this.bShowGrid = new Button((Composite)gStyling, 32);
        this.bShowGrid.setText("Show &Grid");
        this.bShowGrid.setToolTipText("Toggle Background Grid Visibility");
        this.bShowGrid.setSelection(this.data.showGrid);
        GridDataFactory.fillDefaults().indent(0, 0).span(1, 1).grab(false, false).applyTo((Control)this.bShowGrid);
        this.gridColor = new ColorSelector((Composite)gStyling);
        this.gridColor.getButton().setToolTipText("Select Grid Color");
        GridDataFactory.fillDefaults().indent(0, 0).span(1, 1).grab(false, false).applyTo((Control)this.gridColor.getButton());
        this.gridColor.setColorValue(ChartDialog.toRGB(this.data.gridColor, DEFAULT_GRID_COLOR));
        Button bResetGridColor = new Button((Composite)gStyling, 8);
        bResetGridColor.setText("Reset");
        bResetGridColor.setToolTipText("Reset Grid Color to Default");
        bResetGridColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartDialog.this.gridColor.setColorValue(ChartDialog.toRGB(null, DEFAULT_GRID_COLOR));
            }
        });
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)new Label((Composite)gStyling, 0));
        this.bMilestones = new Button((Composite)gStyling, 32);
        this.bMilestones.setText("Show &Milestones");
        this.bMilestones.setToolTipText("Toggle Milestone Event Visibility");
        this.bMilestones.setSelection(this.data.showMilestones);
        GridDataFactory.fillDefaults().indent(0, 0).span(4, 1).applyTo((Control)this.bMilestones);
        Group gItemVisibility = new Group(c, 0);
        gItemVisibility.setText("Item Visibility");
        GridDataFactory.fillDefaults().indent(0, 5).grab(true, true).span(9, 1).applyTo((Control)gItemVisibility);
        GridLayoutFactory.fillDefaults().margins(8, 8).numColumns(3).applyTo((Composite)gItemVisibility);
        Label visible = new Label((Composite)gItemVisibility, 0);
        visible.setText("Visible");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)visible);
        new Label((Composite)gItemVisibility, 0);
        Label hidden = new Label((Composite)gItemVisibility, 0);
        hidden.setText("Hidden");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hidden);
        this.lVisibleItems = new ListViewer((Composite)gItemVisibility, 2818);
        GridDataFactory.fillDefaults().hint(200, 200).grab(true, true).applyTo(this.lVisibleItems.getControl());
        Composite addRemoveButtons = new Composite((Composite)gItemVisibility, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(addRemoveButtons);
        GridDataFactory.fillDefaults().grab(false, true).span(1, 1).applyTo((Control)addRemoveButtons);
        Button hideButton = new Button(addRemoveButtons, 8);
        hideButton.setText("&Hide \u2192");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)hideButton);
        Button showButton = new Button(addRemoveButtons, 8);
        showButton.setText("\u2190 &Show");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)showButton);
        this.lHiddenItems = new ListViewer((Composite)gItemVisibility, 2818);
        GridDataFactory.fillDefaults().hint(200, 200).grab(true, true).applyTo(this.lHiddenItems.getControl());
        this.lVisibleItems.addDoubleClickListener((IDoubleClickListener)new OpenChartItemProperties());
        this.lVisibleItems.setContentProvider((IContentProvider)new ItemContentProvider(false));
        this.lHiddenItems.addDoubleClickListener((IDoubleClickListener)new OpenChartItemProperties());
        this.lHiddenItems.setContentProvider((IContentProvider)new ItemContentProvider(true));
        this.lVisibleItems.setLabelProvider((IBaseLabelProvider)new ItemLabeler());
        this.lHiddenItems.setLabelProvider((IBaseLabelProvider)new ItemLabeler());
        this.lVisibleItems.setInput((Object)this.data);
        this.lHiddenItems.setInput((Object)this.data);
        this.lVisibleItems.getList().addKeyListener((KeyListener)new SelectAllListener(this.lVisibleItems));
        this.lHiddenItems.getList().addKeyListener((KeyListener)new SelectAllListener(this.lHiddenItems));
        showButton.addSelectionListener((SelectionListener)new ShowHideListener(false));
        hideButton.addSelectionListener((SelectionListener)new ShowHideListener(true));
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.tStartTimeDecor = this.createDecoration((Control)this.tStartTime, 0x1004000, image);
        this.tLengthDecor = this.createDecoration((Control)this.tLength, 0x1004000, image);
    }

    private void setBackgroundGradient(boolean backgroundGradient) {
        this.backgroundColor2.setEnabled(backgroundGradient);
        this.backgroundColor1.getButton().setToolTipText(backgroundGradient ? "Select Gradient Bottom Color" : "Select Solid Color");
    }

    protected Double parseTime(Text text, boolean returnDefault, double defaultValue) {
        if (text == null) {
            return null;
        }
        String s = text.getText();
        Double time = ChartComposite.START_VALIDATOR.parse(s);
        if (time == null) {
            return returnDefault ? Double.valueOf(defaultValue) : null;
        }
        return time;
    }

    protected ControlDecoration createDecoration(Control control, int position, Image image) {
        ControlDecoration d = new ControlDecoration(control, position);
        d.setMarginWidth(2);
        d.setImage(image);
        d.hide();
        return d;
    }

    protected void parseUiToData() {
        this.data.name = this.tName.getText();
        this.data.backgroundColor1 = ChartDialog.toColorComponents(this.backgroundColor1.getColorValue());
        this.data.backgroundColor2 = ChartDialog.toColorComponents(this.backgroundColor2.getColorValue());
        this.data.showGrid = this.bShowGrid.getSelection();
        this.data.gridColor = ChartDialog.toColorComponents(this.gridColor.getColorValue());
        this.data.showMilestones = this.bMilestones.getSelection();
        this.data.trackExperimentTime = this.bTrackExperimentTime.getSelection();
        this.data.axisMode = this.cAxisMode.getSelectionIndex() == 0 ? YAxisMode.SingleAxis : YAxisMode.MultiAxis;
        this.data.timeIncrement = this.sIncrement.getSelection();
        this.data.timeLength = ChartComposite.LENGTH_VALIDATOR.parse(this.tLength.getText());
        this.data.timeStart = ChartComposite.START_VALIDATOR.parse(this.tStartTime.getText());
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId) {
            this.applyPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void applyPressed() {
        if (this.applyAction != null) {
            this.parseUiToData();
            if (!this.baseData.equals((Object)this.data)) {
                this.baseData.readFrom(this.data);
                this.applyAction.run();
            }
        }
    }

    protected void okPressed() {
        this.parseUiToData();
        if (this.applyAction != null && !this.baseData.equals((Object)this.data)) {
            this.applyAction.run();
        }
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Chart");
    }

    public void validate() {
        String startTimeError = ChartComposite.START_VALIDATOR.isValid(this.tStartTime.getText());
        String lengthError = ChartComposite.LENGTH_VALIDATOR.isValid(this.tLength.getText());
        this.setDecoration(this.tStartTimeDecor, startTimeError);
        this.setDecoration(this.tLengthDecor, lengthError);
        boolean ok = startTimeError == null && lengthError == null;
        this.setFinishable(ok);
    }

    private void setDecoration(ControlDecoration decor, String desc) {
        if (decor == null) {
            return;
        }
        if (desc != null) {
            decor.setDescriptionText(desc);
            decor.show();
        } else {
            decor.hide();
        }
    }

    protected void setFinishable(boolean ok) {
        this.getButton(0).setEnabled(ok);
    }

    private static RGB toRGB(float[] components, RGB defaultValue) {
        if (components == null || components.length < 3) {
            return defaultValue;
        }
        Color c = new Color(components[0], components[1], components[2]);
        return new RGB(c.getRed(), c.getGreen(), c.getBlue());
    }

    private static float[] toColorComponents(RGB rgb) {
        return new Color(rgb.red, rgb.green, rgb.blue).getColorComponents(new float[3]);
    }

    class ItemContentProvider
    extends ArrayContentProvider {
        private final boolean expectedHidden;

        public ItemContentProvider(boolean expectedHidden) {
            this.expectedHidden = expectedHidden;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<ChartData.ItemKey> result = new ArrayList<ChartData.ItemKey>();
            for (ChartData.ItemKey item : ChartDialog.this.data.allItems.keySet()) {
                if (ChartDialog.this.data.hiddenItems.contains(item) != this.expectedHidden) continue;
                result.add(item);
            }
            return result.toArray();
        }
    }

    class ItemLabeler
    extends LabelProvider {
        ItemLabeler() {
        }

        public String getText(Object element) {
            ChartData.ItemKey item = (ChartData.ItemKey)element;
            TrendItem ti = ChartDialog.this.data.allItems.get(item);
            return ti.label;
        }
    }

    class OpenChartItemProperties
    implements IDoubleClickListener {
        OpenChartItemProperties() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ChartData.ItemKey item = (ChartData.ItemKey)ISelectionUtils.filterSingleSelection((Object)event.getSelection(), ChartData.ItemKey.class);
            if (item == null) {
                return;
            }
            try {
                ChartAndSubscriptionItemData data = (ChartAndSubscriptionItemData)((Object)Simantics.getSession().syncRequest((Read)new ChartAndSubscriptionItemReadQuery(item.resource.getResource())));
                if (ChartDialog.this.currentItemDialog != null && ChartDialog.this.currentItemDialog.getShell() != null && !ChartDialog.this.currentItemDialog.getShell().isDisposed()) {
                    ChartDialog.this.currentItemDialog.close();
                }
                ChartDialog.this.currentItemDialog = ChartDoubleClickHandler.openChartItemPropertiesDialog(event.getViewer().getControl().getShell(), item.resource.getResource(), data, false);
            }
            catch (DatabaseException databaseException) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.charts", "Problems opening chart item property dialog."));
            }
        }
    }

    static class SelectAllListener
    extends KeyAdapter {
        private ListViewer list;

        public SelectAllListener(ListViewer list) {
            this.list = list;
        }

        public void keyPressed(KeyEvent e) {
            if (e.stateMask == 262144 && e.keyCode == 97) {
                this.list.getList().selectAll();
            }
        }
    }

    class ShowHideListener
    extends SelectionAdapter {
        private boolean hide;

        public ShowHideListener(boolean hide) {
            this.hide = hide;
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection = this.hide ? ChartDialog.this.lVisibleItems.getSelection() : ChartDialog.this.lHiddenItems.getSelection();
            Set selected = ISelectionUtils.filterSetSelection((Object)selection, ChartData.ItemKey.class);
            if (!selected.isEmpty()) {
                if (this.hide) {
                    ChartDialog.this.data.hiddenItems.addAll(selected);
                } else {
                    ChartDialog.this.data.hiddenItems.removeAll(selected);
                }
                ChartDialog.this.lVisibleItems.refresh();
                ChartDialog.this.lHiddenItems.refresh();
            }
        }
    }
}

