/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeMap;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;
import org.simantics.db.common.NamedResource;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.utils.strings.AlphanumComparator;

public class ChartData
extends Bean {
    @Optional
    public String name;
    @Optional
    public Double timeIncrement;
    @Optional
    public Double timeStart;
    @Optional
    public Double timeLength;
    public boolean showMilestones;
    public boolean showGrid;
    public boolean trackExperimentTime;
    public YAxisMode axisMode;
    public boolean backgroundGradient;
    @Optional
    public float[] backgroundColor1;
    @Optional
    public float[] backgroundColor2;
    @Optional
    public float[] gridColor;
    public transient TreeMap<ItemKey, TrendItem> allItems = new TreeMap(ITEM_SORTER);
    public transient HashSet<ItemKey> hiddenItems = new HashSet();
    private static Comparator<ItemKey> ITEM_SORTER = new Comparator<ItemKey>(){

        @Override
        public int compare(ItemKey o1, ItemKey o2) {
            int c = Integer.compare(o1.renderer.ordinal(), o2.renderer.ordinal());
            if (c != 0) {
                return c;
            }
            c = Integer.compare(o1.index, o2.index);
            if (c != 0) {
                return c;
            }
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1.resource.getName(), (Object)o2.resource.getName());
        }
    };

    public void readFrom(ChartData other) {
        super.readFrom((Bean)other);
        this.allItems = new TreeMap(ITEM_SORTER);
        this.allItems.putAll(other.allItems);
        this.hiddenItems = new HashSet<ItemKey>(other.hiddenItems);
    }

    public boolean equals(Object obj) {
        boolean s = super.equals(obj);
        if (!s) {
            return false;
        }
        ChartData other = (ChartData)((Object)obj);
        return this.allItems.equals(other.allItems) && this.hiddenItems.equals(other.hiddenItems);
    }

    public static class ItemKey {
        public final TrendItem.Renderer renderer;
        public final int index;
        public final NamedResource resource;

        public ItemKey(TrendItem.Renderer renderer, int index, NamedResource resource) {
            this.renderer = renderer;
            this.index = index;
            this.resource = resource;
        }
    }
}

