/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.Simantics;
import org.simantics.charts.Activator;
import org.simantics.charts.editor.ChartData;
import org.simantics.charts.editor.ChartKeys;
import org.simantics.charts.ui.CSVExportPlan;
import org.simantics.charts.ui.CSVParamsQuery;
import org.simantics.charts.ui.CSVProgressMonitor;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.history.HistoryException;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.util.ProgressMonitor;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.format.FormattingUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVExporter
implements IRunnableWithProgress {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVExporter.class);
    CSVExportPlan exportModel;

    public CSVExporter(CSVExportPlan exportModel) {
        this.exportModel = exportModel;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        try {
            try {
                this.exportModel(progress.newChild(50, 0));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (DatabaseException e) {
                throw new InvocationTargetException(e);
            }
            catch (BindingException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    void exportModel(SubMonitor mon) throws IOException, DatabaseException, SerializationException, BindingException {
        try {
            try {
                CSVExporter.doExport((IProgressMonitor)mon, this.exportModel.exportLocation, this.exportModel);
            }
            catch (ExecutionException e) {
                LOGGER.error("Failed to CSV export subscrption data", (Throwable)e);
                mon.setCanceled(true);
                ShowMessage.showError((String)"Export failed.", (String)"Internal application error in export. See log for details.");
                mon.setWorkRemaining(0);
            }
        }
        finally {
            mon.setWorkRemaining(0);
        }
    }

    private static Set<Resource> resolveContainingModels(final Collection<Resource> res) throws DatabaseException {
        return (Set)Simantics.getSession().syncRequest((Read)new UniqueRead<Set<Resource>>(){

            public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
                HashSet<Resource> models = new HashSet<Resource>();
                for (Resource r : res) {
                    Resource m = (Resource)graph.syncRequest((Read)new PossibleModel(r));
                    if (m == null) continue;
                    models.add(m);
                }
                return models;
            }
        });
    }

    public static void doExport(IProgressMonitor monitor, File f, CSVExportPlan plan) throws ExecutionException, IOException {
        Set<Resource> models;
        IScopeContext context = InstanceScope.INSTANCE;
        IEclipsePreferences node = context.getNode("org.simantics.modeling");
        node.putDouble("csv.start", plan.startTime);
        node.putDouble("csv.step", plan.timeStep);
        node.put("csv.decimal.separator", plan.decimalSeparator.toPreference());
        node.put("csv.value.separator", plan.columnSeparator.toPreference());
        node.putBoolean("csv.resample", plan.resample);
        node.put("csv.sampling.mode", plan.samplingMode.toPreference());
        node.putInt("csv.format.time.digits", plan.timeDigits);
        node.putInt("csv.format.float.digits", plan.floatDigits);
        node.putInt("csv.format.double.digits", plan.doubleDigits);
        try {
            node.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.charts", "Could not store preferences for node " + node.absolutePath()));
        }
        try {
            models = CSVExporter.resolveContainingModels(plan.items);
        }
        catch (DatabaseException e3) {
            throw new ExecutionException("Containing model resolution failed.", (Throwable)e3);
        }
        if (models.isEmpty()) {
            throw new ExecutionException("Selected resources are not part of any model");
        }
        if (models.size() > 1) {
            throw new ExecutionException("Selected resources are part of several models, only subscriptions from a single model can be selected");
        }
        Resource model = models.iterator().next();
        ChartKeys.ChartSourceKey chartDataKey = ChartKeys.chartSourceKey(model);
        ChartData data = (ChartData)Simantics.getProject().getHint((IHintContext.Key)chartDataKey);
        if (data == null) {
            throw new ExecutionException("There is no " + String.valueOf((Object)chartDataKey));
        }
        if (data.history == null) {
            throw new ExecutionException("There is no history in " + String.valueOf((Object)chartDataKey));
        }
        CSVFormatter csv = new CSVFormatter();
        csv.setStartTime(plan.startTime);
        csv.setTimeStep(plan.timeStep);
        csv.setDecimalSeparator(plan.decimalSeparator);
        csv.setColumnSeparator(plan.columnSeparator);
        csv.setResample(plan.resample);
        csv.setNumberInterpolation(plan.samplingMode);
        csv.setTimeFormat(FormattingUtils.significantDigitFormat((int)plan.timeDigits));
        csv.setFloatFormat(FormattingUtils.significantDigitFormat((int)plan.floatDigits));
        csv.setNumberFormat(FormattingUtils.significantDigitFormat((int)plan.doubleDigits));
        try {
            try {
                Charset cs = Charset.forName(plan.encoding);
                String csn = cs.name();
                Simantics.getSession().syncRequest((Read)new CSVParamsQuery(data.history, csv, new ArrayList<Resource>(plan.items)));
                csv.sort();
                monitor.beginTask("Exporting Time Series as CSV...", -1);
                data.collector.flush();
                Throwable throwable = null;
                Throwable throwable2 = null;
                try (RandomAccessFile raf = new RandomAccessFile(f, "rw");){
                    raf.setLength(0L);
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                boolean exportSepHeader = csn.equals("UTF-8") || csn.equals("US-ASCII");
                throwable2 = null;
                Object var14_20 = null;
                try (PrintStream ps = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(f, true)), false, cs);){
                    if (exportSepHeader) {
                        ps.append("sep=" + plan.columnSeparator.preference + "\n");
                    }
                    csv.formulate2((ProgressMonitor)new CSVProgressMonitor(monitor), (Appendable)ps);
                    ps.flush();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
                monitor.setTaskName("Done");
            }
            catch (IllegalArgumentException | DatabaseException | HistoryException e) {
                throw new ExecutionException(e.getMessage(), e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

