/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.management.ISessionContext;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.history.csv.ExportInterpolation;
import org.simantics.project.IProject;

public class CSVExportPlan {
    ISessionContext sessionContext;
    IProject project;
    Object selection;
    Deque<String> recentLocations;
    Collection<Resource> items = new HashSet<Resource>();
    File exportLocation;
    public double startTime;
    public double timeStep;
    public DecimalSeparator decimalSeparator;
    public ColumnSeparator columnSeparator;
    public boolean resample;
    public ExportInterpolation samplingMode;
    public int timeDigits;
    public int floatDigits;
    public int doubleDigits;
    public String encoding;
    boolean overwrite;

    public CSVExportPlan(double startTime, double timeStep, DecimalSeparator dsep, ColumnSeparator csep, boolean resample, ExportInterpolation mode, int timeDigits, int floatDigits, int doubleDigits) {
        this.sessionContext = Simantics.getSessionContext();
        this.recentLocations = new ArrayDeque<String>();
        this.startTime = startTime;
        this.timeStep = timeStep;
        this.decimalSeparator = dsep;
        this.columnSeparator = csep;
        this.resample = resample;
        this.samplingMode = mode;
        this.timeDigits = timeDigits;
        this.floatDigits = floatDigits;
        this.doubleDigits = doubleDigits;
        this.encoding = Charset.defaultCharset().name();
    }

    public CSVExportPlan setItems(List<Resource> items) {
        this.items = items;
        return this;
    }

    public CSVExportPlan setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    CSVExportPlan(ISessionContext sessionContext, Deque<String> recentLocations) {
        this.sessionContext = sessionContext;
        this.recentLocations = recentLocations;
    }
}

