/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.utils.format.TimeFormat;

public class TimeInputValidator
implements IInputValidator {
    public static final TimeInputValidator INSTANCE = new TimeInputValidator(-1.7976931348623157E308);
    public Format decimalFormat = new DecimalFormat("0");
    public Format timeFormat = new TimeFormat(100.0, 0);
    double minValue;

    public TimeInputValidator(double minValue) {
        this.minValue = minValue;
    }

    public Double parse(String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).equals("")) {
            return null;
        }
        try {
            return (Double)this.timeFormat.parseObject(text);
        }
        catch (ParseException parseException) {
            try {
                Number n = (Number)this.decimalFormat.parseObject(text);
                if (n instanceof Double) {
                    return (Double)n;
                }
                return n.doubleValue();
            }
            catch (ParseException parseException2) {
                return null;
            }
        }
    }

    public String isValid(String text) {
        if (text == null) {
            return "Null";
        }
        if ((text = text.trim()).equals("")) {
            return null;
        }
        try {
            Double d = (Double)this.timeFormat.parseObject(text);
            if (d != null && d < this.minValue) {
                return "Value must be at least " + this.minValue + " seconds.";
            }
            return null;
        }
        catch (ParseException parseException) {
            try {
                Number n = (Number)this.decimalFormat.parseObject(text);
                if (n != null && n.doubleValue() < this.minValue) {
                    return "Value must be at least " + this.minValue + " seconds.";
                }
                return null;
            }
            catch (ParseException e) {
                return e.toString();
            }
        }
    }
}

