/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import org.simantics.databoard.util.ObjectUtils;

/**
 * Shared time in the desktop environment when analysing data. 
 *
 * @author toni.kalajainen@semantum.fi
 */
public class ChartLinkData /*extends Bean*/ {
	
    // Actually is TimeSeriesEditor itself
	public transient Object sender;
	public double from, end, sx;
	public Double valueTipTime; 

	public ChartLinkData() {}
	
	public ChartLinkData(Object sender, double from, double end, double sx) {
		this.sender = sender;
		this.from = from;
		this.end = end;
		this.sx = sx;
	}	
	
	@Override
	public int hashCode() {
    	long bits1 = Double.doubleToLongBits(from);
    	long bits2 = Double.doubleToLongBits(end);
    	long bits3 = Double.doubleToLongBits(sx);
    	long bits4 = valueTipTime==null?0:Double.doubleToLongBits(valueTipTime);
    	int hash = (int) (
    			(bits1 ^ (bits1 >>> 32)) + 
    			(bits2 ^ (bits2 >>> 32)) +
    			(bits3 ^ (bits3 >>> 32)) +
    			(bits4 ^ (bits4 >>> 32)) );
    	return hash;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj ==null) return false;
		if (obj instanceof ChartLinkData==false) return false;
		ChartLinkData other = (ChartLinkData) obj;
		return from==other.from &&
				end==other.end &&
				sx==other.sx &&
				ObjectUtils.objectEquals(valueTipTime, other.valueTipTime);
	}

}
