/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.browsing.ui.model.modifiers.NoModifierRule;
import org.simantics.browsing.ui.model.modifiers.StringPropertyModifierRule;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class ChartItemNameModifierRule extends StringPropertyModifierRule {

    public ChartItemNameModifierRule(ReadGraph graph) throws DatabaseException {
        super(graph, Layer0.URIs.HasLabel);
    }

    @Override
    public Modifier getModifier(ReadGraph graph, Object content, String columnKey) throws DatabaseException {
        if (!ColumnKeys.SINGLE.equals(columnKey))
            return null;
        if (!(content instanceof Resource))
            return null;

        Resource resource = (Resource)content;
        ChartResource CHART = ChartResource.getInstance(graph);
        Resource subscriptionItemResource = graph.getPossibleObject(resource, CHART.Chart_Item_HasSubscriptionItem);
        if (subscriptionItemResource == null)
            return NoModifierRule.NO_MODIFIER;

        return super.getModifier(graph, subscriptionItemResource, columnKey);
    }

}