/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.charts.query.ChartAndSubscriptionItemData;
import org.simantics.charts.query.ChartAndSubscriptionItemReadQuery;
import org.simantics.charts.query.ChartAndSubscriptionItemWriteAction;
import org.simantics.charts.query.ChartDataQuery;
import org.simantics.charts.query.ChartDataWrite;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.dialogs.ShowError;

public class ChartDoubleClickHandler implements IDoubleClickAction {

    @Override
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        final Resource resource = ResourceAdaptionUtils.toSingleResource(e.getResource());
        if (resource == null)
            return;

        ChartResource CHART = ChartResource.getInstance(g);
        
        // Handle double-click on Chart Item.
        if (g.isInstanceOf(resource, CHART.Chart_Item)) {
            Display display = Display.getDefault();
        	openChartItemPropertiesDialog(g, resource, display);
        	e.consume();
        }
        /*
        if (g.isInstanceOf(resource, CHART.Chart)) {
            Display display = Display.getDefault();
        	openChartPropertiesDialog(g, resource, display);
        	e.consume();
        }
        */
    }

    public static void openChartItemPropertiesDialog(ReadGraph g, final Resource chartItem, final Display display) throws DatabaseException
    {
        final ChartAndSubscriptionItemData data = g.sync( new ChartAndSubscriptionItemReadQuery(chartItem) );
        display.asyncExec(new Runnable() {
            @Override
            public void run() {
                openChartItemPropertiesDialog(display.getActiveShell(), chartItem, data, true);
            }
        });
    }

    public static ChartAndSubscriptionItemDialog openChartItemPropertiesDialog(
            Shell parentShell,
            final Resource chartItem,
            final ChartAndSubscriptionItemData data,
            boolean shouldBlock)
    {
        Runnable applyAction = new Runnable() {
            @Override
            public void run() {
                try {
                    Session s = Simantics.getSession();
                    s.markUndoPoint();
                    s.sync( new ChartAndSubscriptionItemWriteAction(chartItem, data) );
                } catch (DatabaseException e) {
                    ShowError.showError(e.getClass().getName(), e.getLocalizedMessage(), e);
                }
            }
        };
        ChartAndSubscriptionItemDialog d =  new ChartAndSubscriptionItemDialog( parentShell, data, true, applyAction );
        d.setBlockOnOpen(shouldBlock);
        if (shouldBlock) {
            d.open();
            return null;
        } else {
            d.open();
            return d;
        }
    }

    public static void openChartPropertiesDialog(ReadGraph g, final Resource chart, final Display display) throws DatabaseException
    {
        final ChartData data = g.sync( new ChartDataQuery(chart) );

        display.asyncExec( new Runnable() {
            @Override
            public void run() {
                Display display = Display.getCurrent();
                Runnable applyAction = new Runnable() {
                    @Override
                    public void run() {
                        try {
                            Session s = Simantics.getSession();
                            s.markUndoPoint();
                            s.sync( new ChartDataWrite(chart, data) );
                        } catch (DatabaseException e) {
                            ShowError.showError(e.getClass().getName(), e.getLocalizedMessage(), e);
                        }
                    }
                };
                ChartDialog d =  new ChartDialog( display.getActiveShell(), data, applyAction );
                d.open();
            }
        });
    }

}
