/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.history.util.ProgressMonitor;

/**
 * @author Tuukka Lehtonen
 */
public class CSVProgressMonitor implements ProgressMonitor {

    private IProgressMonitor monitor;

    public CSVProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void beginTask(String name, int totalWork) {
        monitor.beginTask(name, totalWork);
    }

    @Override
    public boolean isCanceled() {
        return monitor.isCanceled();
    }

    @Override
    public void setTaskName(String name) {
        monitor.setTaskName(name);
    }

    @Override
    public void subTask(String name) {
        monitor.subTask(name);
    }

    @Override
    public void worked(int work) {
        monitor.worked(work);
    }

}