package org.simantics.charts.ui;

import java.util.Collections;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.ItemManager;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.subscription.SubscriptionItemLabel;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * This query adds items to the given CSVFormatter.
 */
class CSVParamsQuery extends ReadRequest {
	CSVFormatter csv;
	List<Resource> subscriptionItems;
	ItemManager im;
	HistoryManager history;
	
	public CSVParamsQuery(HistoryManager history, CSVFormatter csv, List<Resource> subscriptionItems) throws HistoryException {
		super();
		this.csv = csv;
		this.subscriptionItems = subscriptionItems;		
		this.history = history;
		im = new ItemManager( history.getItems() );
	}

	@Override
	public void run(ReadGraph graph) throws DatabaseException {
    	Layer0 L0 = Layer0.getInstance(graph);
    	ModelingResources MOD = ModelingResources.getInstance(graph);
    	SimulationResource SIM = SimulationResource.getInstance(graph);

		for (Resource si : subscriptionItems) {
            //Resource subscription = graph.syncRequest( new PossibleTypedParent(si, MOD.Subscription) );
			String unit = graph.getPossibleRelatedValue(si, MOD.Subscription_Item_Unit, Bindings.STRING);
			//String name = graph.getRelatedValue(subject, relation)
			String subscriptionItemLabel = graph.getPossibleRelatedValue(si, L0.HasLabel, Bindings.STRING);
			String label2 = null;
			String groupItemId = graph.getPossibleRelatedValue(si, L0.HasName, Bindings.STRING);
			if (groupItemId == null)
				continue;
			//String groupId = graph.getPossibleRelatedValue(subscription, L0.HasName, Bindings.STRING);

        	Binding rviBinding = graph.getService(Databoard.class).getBindingUnchecked( RVI.class );
            RVI rvi = graph.getPossibleRelatedValue(si, MOD.Subscription_Item_VariableId, rviBinding);
            if (rvi != null) {
                Resource model = graph.syncRequest( new PossibleTypedParent(si, SIM.Model) );
                Variable configuration = null;
                if (model!=null) configuration = Variables.getConfigurationContext(graph, model);

                // Label
                if ((subscriptionItemLabel == null || subscriptionItemLabel.isEmpty()) && configuration!=null) {
                    subscriptionItemLabel = rvi.asPossibleString(graph, configuration);
                    if (subscriptionItemLabel == null)
                        subscriptionItemLabel = rvi.toPossibleString(graph, configuration);
                    if (subscriptionItemLabel != null) {
                        subscriptionItemLabel = SubscriptionItemLabel.removeVariablePrefixPath(subscriptionItemLabel);
                        subscriptionItemLabel = URIStringUtils.unescape(subscriptionItemLabel);
                    }
                }

                // Variable name
                if (configuration != null) {
                    label2 = rvi.toPossibleString(graph, configuration);
                    if (label2 == null)
                        continue;
                    label2 = URIStringUtils.unescape( label2 );
                } else {
                    label2 = rvi.toString();
                }
            }

            List<Bean> streams;
			try {
				streams = im.search("groupItemId", groupItemId);
	            Collections.sort(streams, SamplingFormat.INTERVAL_COMPARATOR);
	            if (!streams.isEmpty()) {            	
	                Bean config = streams.get(0);
	                String id = (String) config.getFieldUnchecked("id");
	                csv.addItem( history, id, subscriptionItemLabel, label2, unit);
	            }
			} catch (BindingException e) {
				// There is no id
			}
		}
	}

}