package org.simantics.charts.query;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class SetProperty extends WriteRequest {

    private Resource entity;
    private Resource property;
    private Object value;
    private Binding binding;

    public SetProperty(Resource entity, Resource property, Object value, Binding binding) {
        this.entity = entity;
        this.property = property;
        this.value = value;
        this.binding = binding;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        graph.claimLiteral(entity, property, value, binding);
    }

}
