/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.query;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * Query to chart for next available item index.
 * This is the largest item index found + 1.
 * 
 * @author toni.kalajainen
 */
public class NextChartItemIndexQuery extends ResourceRead<Integer> {

	public NextChartItemIndexQuery(Resource resource) {
		super(resource);
	}

	@Override
	public Integer perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        ChartResource CHART = ChartResource.getInstance(graph);
		
        int largest = 0;
        for (Resource item : graph.syncRequest(Queries.objectsWithType(resource, L0.ConsistsOf, CHART.Chart_Item))) {
        	Integer index = graph.getPossibleRelatedValue(item, CHART.Chart_Item_Index);
        	if (index != null) largest = Math.max(largest, index);
        }
        
		return largest+1;
	}

}
