package org.simantics.charts.query;

import java.util.List;

import org.simantics.Simantics;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 * @since 1.20
 */
public class HideChartItems extends WriteRequest {

    private final Boolean hide;
    private final List<Resource> items;

    public HideChartItems(boolean hide, List<Resource> items) {
        this.hide = hide;
        this.items = items;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        hideChartItems(graph, hide, items);
    }

    public static void hideChartItems(WriteGraph graph, boolean hide, List<Resource> items) throws DatabaseException {
        ChartResource CHART = ChartResource.getInstance(graph);
        for (Resource item : items) {
            if (graph.isInstanceOf(item, CHART.Chart_Item)) {
                graph.claimLiteral(item, CHART.Chart_Item_hidden, hide, Bindings.BOOLEAN);
            }
        }
    }

    public static void hideChartItems(boolean hide, List<Resource> items) throws DatabaseException {
        Session s = Simantics.getSession();
        s.markUndoPoint();
        s.syncRequest(new HideChartItems(hide, items));
    }

}