/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.query;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;

public class ChartItemIndexQuery extends ResourceRead<Integer> {

	public ChartItemIndexQuery(Resource resource) {
		super(resource);
	}

	@Override
	public Integer perform(ReadGraph graph) throws DatabaseException {
		ChartResource CHART = ChartResource.getInstance(graph);
		return graph.getPossibleRelatedValue(resource, CHART.Chart_Item_Index, Bindings.INTEGER);
	}

}
