/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.query;

import java.util.UUID;

import org.simantics.databoard.annotations.Optional;
import org.simantics.db.Resource;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem.DrawMode;
import org.simantics.trend.configuration.TrendItem.Renderer;

/**
 * Descriptor for creation of a Chart Item
 * @author toni.kalajainen
 *
 */
public class ChartItemDescriptor {

    public String name = UUID.randomUUID().toString();

    /**
     * Subscription item to link chart item to
     */
    public @Optional Resource subscriptionItem = null;

    public Scale scale = new Scale.Auto();
    public @Optional Double min;
    public @Optional Double max;
    public @Optional Integer index;

    public Renderer renderer = Renderer.Analog;

    public DrawMode drawMode = DrawMode.getDefault();

    public @Optional Float strokeWidth;
    public @Optional float[] color; 

}
