/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.preference;

import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Range;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.util.Bean;

public class ChartTimeWindowTemplate extends Bean {

	public static final ChartTimeWindowTemplate WholeHistory, Last60Seconds, Last10Minutes;
	public static final String[][] radioGroup;
	
	public String id;
	public String Label;
	public String uri;
	public @Unit("s") @Optional Double HasTimeWindowStart; 
	public @Unit("s") @Optional Double TimeWindowLength;
	public @Range("[0..100]")  @Optional Double TimeWindowIncrement;
	
	public static ChartTimeWindowTemplate getTemplate(String id)
	{
		if (id.equals(WholeHistory.id)) return WholeHistory;
		if (id.equals(Last60Seconds.id)) return Last60Seconds;
		if (id.equals(Last10Minutes.id)) return Last10Minutes;
		return null;
	}
	
	static {
		WholeHistory = new ChartTimeWindowTemplate();
		WholeHistory.id = "WholeHistory";
		WholeHistory.Label = "Whole History";
		WholeHistory.TimeWindowIncrement = 50.0;
		WholeHistory.uri = ChartResource.URIs.WholeHistoryChartTemplate;

		Last60Seconds = new ChartTimeWindowTemplate();
		Last60Seconds.id = "Last60Seconds";
		Last60Seconds.Label = "Last 60 Seconds";
		Last60Seconds.TimeWindowIncrement = 50.0;
		Last60Seconds.TimeWindowLength = 60.0;
		Last60Seconds.uri = ChartResource.URIs.Last60SecondsChartTemplate;

		Last10Minutes = new ChartTimeWindowTemplate();
		Last10Minutes.id = "Last10Minutes";
		Last10Minutes.Label = "Last 10 Minutes";
		Last10Minutes.TimeWindowIncrement = 50.0;
		Last10Minutes.TimeWindowLength = 600.0;
		Last10Minutes.uri = ChartResource.URIs.Last10MinutesChartTemplate;
		
		radioGroup = 
			new String[][] { 
				{ WholeHistory.Label, WholeHistory.id }, 
				{ Last60Seconds.Label, Last60Seconds.id }, 
				{ Last10Minutes.Label, Last10Minutes.id } 
			};
	}
	
	public static void main(String[] args) throws Exception {
				
		System.out.println( WholeHistory );
		System.out.println( Last60Seconds );
		System.out.println( Last10Minutes );
		
	}
	
}
