/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.preference;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.charts.Activator;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.LineQuality;

/**
 * @author Toni Kalajainen
 */
public class ChartPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    private IntegerFieldEditor fRedrawIntervalEditor = null;
    private IntegerFieldEditor fAutoscaleIntervalEditor = null;
    private BooleanFieldEditor fDrawSamplesEditor = null;
    private RadioGroupFieldEditor fTimeFormatEditor = null;
    private RadioGroupFieldEditor fItemPlacementEditor = null;
    private RadioGroupFieldEditor fValueFormatEditor = null;
    private IntegerFieldEditor fDecimalDigitsEditor = null;
    private RadioGroupFieldEditor fLineQualityEditor = null;
    private RadioGroupFieldEditor fTextQualityEditor = null;


    /**
     * Create the console page.
     */
    public ChartPreferencePage() {
        super(GRID);

        //setDescription("Chart prefrences");
        setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#createControl(Composite)
     */
    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    /**
     * Create all field editors for this page
     */
    @Override
    public void createFieldEditors() {
        fRedrawIntervalEditor = new IntegerFieldEditor(ChartPreferences.P_REDRAW_INTERVAL, Messages.ChartPreferencePage_redrawIntervalLabel, getFieldEditorParent());
        fRedrawIntervalEditor.setValidRange(1, Integer.MAX_VALUE);
        fRedrawIntervalEditor.setErrorMessage(Messages.ChartPreferencePage_redrawIntervalInvalid);
        addField(fRedrawIntervalEditor);

        fAutoscaleIntervalEditor = new IntegerFieldEditor(ChartPreferences.P_AUTOSCALE_INTERVAL, Messages.ChartPreferencePage_autoscaleIntervalLabel, getFieldEditorParent());
        fAutoscaleIntervalEditor.setValidRange(1, Integer.MAX_VALUE);
        fAutoscaleIntervalEditor.setErrorMessage(Messages.ChartPreferencePage_autoscaleIntervalInvalid);
        addField(fAutoscaleIntervalEditor);

        fDrawSamplesEditor = new BooleanFieldEditor(ChartPreferences.P_DRAW_SAMPLES, Messages.ChartPreferencePage_drawSamplesLabel, getFieldEditorParent());
        addField(fDrawSamplesEditor);
        
        fTimeFormatEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_TIMEFORMAT,
        		"Preferred time format",
        		1,
        		new String[][] {
            			new String[] {"Time", TimeFormat.Time.name()},	
            			new String[] {"Decimal", TimeFormat.Decimal.name()}	
        		},
        		getFieldEditorParent());
        addField(fTimeFormatEditor);
        
        fValueFormatEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_VALUEFORMAT,
        		"Preferred value format",
        		1,
        		new String[][] {
            			new String[] {"Default", "Default"},	
            			new String[] {"Decimal", "Currency"},
            			new String[] {"Scientific", "Scientific"},	
            			new String[] {"Engineering", "Engineering"}	
        		},
        		getFieldEditorParent());
        addField(fValueFormatEditor);

        fDecimalDigitsEditor = new IntegerFieldEditor(ChartPreferences.P_DECIMAL_DIGITS, "Max number of decimal digits in decimal values", getFieldEditorParent());
        fDecimalDigitsEditor.setValidRange(0, 15);
        fDecimalDigitsEditor.setErrorMessage("Number of decimal digits must be between [0,15]");
        addField(fDecimalDigitsEditor);

        fItemPlacementEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_ITEMPLACEMENT,
        		"Item autoscale placement",
        		1,
        		new String[][] {
            			new String[] {"Stacked", ItemPlacement.Stacked.name()},	
            			new String[] {"Overlapping", ItemPlacement.Overlapping.name()}	
        		},
        		getFieldEditorParent());
        addField(fItemPlacementEditor);

        fLineQualityEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_LINEQUALITY,
        		"Line Quality",
        		1,
        		new String[][] {
            			new String[] {"Normal", LineQuality.Normal.name()},	
            			new String[] {"Anti-alias", LineQuality.Antialias.name()}	
        		},
        		getFieldEditorParent());
        addField( fLineQualityEditor );
        
        fTextQualityEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_TEXTQUALITY,
        		"Text Quality",
        		1,
        		new String[][] {
            			new String[] {"Normal", LineQuality.Normal.name()},	
            			new String[] {"Anti-alias", LineQuality.Antialias.name()}	
        		},
        		getFieldEditorParent());
        addField( fTextQualityEditor );
        
    }

    /**
     * @see IWorkbenchPreferencePage#init(IWorkbench)
     */
    @Override
    public void init(IWorkbench workbench) {
    }


}
