/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.preference;

import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.charts.Activator;
import org.simantics.trend.configuration.YAxisMode;

public class ChartDefaultsPage extends FieldEditorPreferencePage implements
		IWorkbenchPreferencePage {

	private RadioGroupFieldEditor fTimeWindowTemplateEditor = null;
    private RadioGroupFieldEditor fAxisModeEditor = null;
    //private RadioGroupFieldEditor fDrawModeEditor = null;
    private RadioGroupFieldEditor fScaleModeEditor = null;

	public ChartDefaultsPage() {
        super(GRID);

        //setDescription("Chart prefrences");
        setPreferenceStore(Activator.getDefault().getPreferenceStore());
	}
    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
    }

	@Override
	public void init(IWorkbench workbench) {
		// TODO Auto-generated method stub

	}

    /**
     * Create all field editors for this page
     */
    @Override
    public void createFieldEditors() {
    	Label label = new Label(getFieldEditorParent(), 0);
    	label.setText("Default values for new charts and chart items:");
        
        fTimeWindowTemplateEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_TIMEWINDOW_TEMPLATE,
        		"Time window template",
        		1,
        		ChartTimeWindowTemplate.radioGroup,
        		getFieldEditorParent());
        addField(fTimeWindowTemplateEditor);
        
        fAxisModeEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_AXISMODE,
        		"Axis Mode",
        		1,
        		new String[][] {
            			new String[] {"Single axis", YAxisMode.SingleAxis.name()},	
            			new String[] {"Multi axis", YAxisMode.MultiAxis.name()}	
        		},
        		getFieldEditorParent());
        addField(fAxisModeEditor);
        
//        fDrawModeEditor = new RadioGroupFieldEditor(
//        		ChartPreferences.P_DRAWMODE,
//        		"Draw Mode",
//        		1,
//        		new String[][] {
//            			new String[] {"Line", DrawMode.Line.name()},	
//            			new String[] {"Sample", DrawMode.Sample.name()},	
//            			new String[] {"Average", DrawMode.Average.name()},	
//            			new String[] {"Deviation", DrawMode.Deviation.name()},	
//            			new String[] {"Line and deviation", DrawMode.DeviationAndLine.name()},	
//            			new String[] {"Sample and deviation", DrawMode.DeviationAndSample.name()},	
//            			new String[] {"Average and deviation", DrawMode.DeviationAndAverage.name()}	
//        		},
//        		getFieldEditorParent());
//        addField(fDrawModeEditor);
        
        fScaleModeEditor = new RadioGroupFieldEditor(
        		ChartPreferences.P_SCALEMODE,
        		"Scale Mode",
        		1,
        		new String[][] {
            			new String[] {"Auto", "Auto"},	
            			new String[] {"Manual", "Manual"}	
        		},
        		getFieldEditorParent());
        addField(fScaleModeEditor);
        
    }

}
