/*******************************************************************************
 * Copyright (c) 2007, 2011 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.RuntimeAdaptException;

public class BooleanToDoubleAdapter implements Adapter {

	public static final BooleanToDoubleAdapter INSTANCE = new BooleanToDoubleAdapter();
	
	@Override
	public Object adapt(Object obj) throws AdaptException {
		Boolean b = (Boolean) obj;
		return b ? 1.0 : 0.0;
	}

	@Override
	public Object adaptUnchecked(Object obj) throws RuntimeAdaptException {
		Boolean b = (Boolean) obj;
		return b ? 1.0 : 0.0;
	}

}

