/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.tests;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.InvalidVariableException;
import org.simantics.db.layer0.variable.Variable;

public enum HasURITest implements Test
{
    INSTANCE;


    public static HasURITest get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
        if (content instanceof Resource) {
            return graph.getPossibleURI((Resource)content) != null;
        }
        if (content instanceof Variable) {
            try {
                Variable v = (Variable)content;
                return v.getURI(graph) != null;
            }
            catch (InvalidVariableException invalidVariableException) {
                return false;
            }
        }
        return false;
    }
}

