/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.modifiers;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.modifiers.ModifierRule;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class ModifierContribution
extends VisualsContribution {
    ModifierRule modifierRule;

    public ModifierContribution(NodeType nodeType, Test test, ModifierRule modifierRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if (!modifierRule.isCompatible(nodeType.getContentType())) {
            throw new InvalidContribution("Label rule is not compatible with the content type.");
        }
        this.modifierRule = modifierRule;
    }

    public Labeler.Modifier getModifier(ReadGraph graph, NodeContext context, String columnKey) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.modifierRule.getModifier(graph, content, columnKey);
            }
            return null;
        }
        catch (DatabaseException e) {
            return new Labeler.DeniedModifier(e.getMessage());
        }
    }
}

